import json
from typing import Union
import re
from .utils import text_punc_fix,text_word_fix

# - Causal Relationship: The causal relationship between this event and the other event.

# 输入小说片段，提取成单幕情节链
SYSTEM_PLOTLINE = """Input a novel segment and extract it into an act with several plotlines.

## Steps:

1. Read and Analyze:
   - You will reveive the following materials, please read and understand them thoroughly:
     - Current Novel Chapters
     - Subsequent Reference Chapters
     - Previous Act Information
   - You should take the Current Novel Chapters into a drama act.

2. Extract and Organize Information:
   - Extract the corresponding information in units of the act.
   - Organize the extracted information into the following categories:
     - Basic content.
     - Plot chains list.
     - Main plots list.
     - Minor plots list.

3. Ensure Format Compliance:
   - Organize the contents strictly according to the format of the provided Output Example.
   - Output the results in a JSON format.

## Attention Points:

1. Basic Content Composition:
   - Find all the characters who appeared in Current Novel Chapters. Divide them into Main Characters and Minor Characters.
   - Ensure that each character's name is unique and cannot be pronoun.

2. Plot Chain Composition:
   - Each event in the plot chain includes the following elements:
     - Diegesis: The narrative mode of this event. e.g. Fast-Pace Narration, Slow-Pace Narration, Turning Point, Flashback, Flashforward.
     - Description: One sentence summary of this event, including key elements such as time, place, characters, and environment.
     - Place and Time: Where this event takes place and when this event takes place.
     - Background: What happened before this event. The initial environment and initial states of the characters in this scene.
     - Detailed: The detailed cause, development and outcome of this event.
     - End Suspense: The suspense left by this event. If there is no suspense in the end, simply write "None".
     - Associated Characters: The characters involved in this event.
   - Avoid repetition or omission of novel content between events when forming the plot chain.
   - The number of events in the plot chain should align with the actual plot development in Current Novel Chapters, neither too many nor too few.
   - If the user specifies a limit on the number of plot chain events, the output should adhere to this limit.

3. Continuity and Consistency:
   - If the user provides The Previous Act Information (in JSON format), continue extracting information from the current chapters based on this provided information. Ensure that the first event in newly extracted plot chain is seamlessly continued from the provided plot chain in Previous Act Information.
   - Ensure that the Subsequent Reference Chapters is seamlessly continued from the last event in the newly extracted plot chain.

## Output Example:

Your final output should ALWAYS strictly in the following JSON format example:

```json 
{output_format}
```
"""

USER_PLOTLINE = """Please read the Current Novel Chapters, Subsequent Reference Chapters, Previous Act Information, and extract the corresponding information in units of the act, including the basic content, plot chains, main plots, minor plots. You need to organize these contents strictly according to the format of the Output Example.

### Current Novel Chapters:
{novel_frags_cur}

### Subsequent Reference Chapters:
{novel_frags_ref}

### Previous Act Information:
{previous_act} 
"""

ADD_PLOTLINE_PARA = """
### The Plot Chain Number Limit: {plot_chain_limit}"""

# 输入小说片段、单幕情节链部分信息，提取成单幕角色传记
SYSTEM_PROFILE = """Input a novel segment and extract it into character profile.

## Steps:

1. Read and Analyze:
   - You will reveive the following materials, please read and understand them thoroughly:
     - Current Novel Chapters
     - Act Basic Information
     - Act Events List
   - You should take the Current Novel Chapters into a character profile based on the Act Basic Information and Act Events List.

2. Extract and Organize Information:
   - Organize the extracted information into the following categories:
     - Character relationships.
     - Character biographies.

3. Ensure Format Compliance:
   - Organize the contents strictly according to the format of the provided Output Example.
   - Output the results in a JSON format.

## Attention Points of Character Biographies:

1. Events ID
   - For each character, find out the ID of events experienced by him or her from the Event List.
   - Each event ID should ALWAYS in the Act Events List. NEVER creat new events ID.
   
2. Monologues and Changes for Each Character
   - Monologue: For each event, tell the self perception and memory from the first person perspective of this character.
   - Changes: Having experienced this event, how would this character's psychology, desires, and other attributes change.

## Output Example:

Your final output should ALWAYS strictly in the following JSON format example:

```json 
{output_format}
```
"""

USER_PROFILE = """Please read the Current Novel Chapters, the Act Basic Information, the Act Events List, and output a character profile, including the Character relationships, and Character biographies. You need to organize these contents strictly according to the format of the Output Example.

### Current Novel Chapters:
{novel_frags}

### Act Basic Information:
{basic_info}

### Events List:
{events_list} 
"""

#    - CAUSAL: Verify the accuracy of the Causal Relationship between events within and between acts.
#    - CAUSAL: Suggest which event's Causal Relationship should be revised. e.g. Act 2-Event 5 should be the preceding event of Act 3-Event 1, and Act 3-Event 1 should be the subsequent event of Act 2-Event 5.

# 后续可以让Agent在self-refine的过程中自动识别整部小说的关键情节和主要人物或修改我们按照第一次提取的情节链中的关键情节和人物提取的整部小说的关键情节/人物
# 输入全幕情节链、角色传记、历史修改意见，对情节链提出若干修改意见
SYSTEM_REFINE = """
You are a executive observer expert skilled in identifying inconsistencies and errors in narrative plots and character developments. Your goal is to review and refine the extracted plot lines across all acts. You can refer to historical errors and suggestions in the Issues History, but try not to repeat them.

## Steps

You will check the plot lines by following these steps:
1. Understand, analyze, and break down the overall narrative structure and the roles of characters.
2. According to the narrative context and the provided plot lines and character profiles, think about the following five different types of issue:
   - EVENTS: Check the consistency and completeness of events within and between acts. Ensure there are no duplicated or inconsistent plot events across the acts.
   - DIEGESIS: Check the narrative mode of this event is judged correctly, contaning Fast-Pace Narration, Slow-Pace Narration, Turning Point, Flashback, Flashforward.
   - CHARACTER PRIORITY: Check whether the division of Main Characters and Minor Characters is reasonable.
   - PLOTS PRIORITY: Check whether the division of Main Plots and Minor Plots is reasonable.
   - DETAILS: Check whether the details of the event are reasonable.

3. Identify any errors or inconsistencies, and provide detailed suggested modification.
   - EVENTS: Specify which act's events should be revised, suggest removal of any duplicate or inconsistent elements.
   - DIEGESIS: Suggest how to revise the diegesis. e.g. Act x-Event y should be Flashback.
   - CHARACTER PRIORITY: Suggest how to revise the division of Main Characters and Minor Characters. e.g. Character C should be divided into Minor Characters List.
   - PLOTS PRIORITY: Suggest how to revise the division of Main Plots and Minor Plots. e.g. Act x-Event y should be divided into Minor Plots List.
   - DETAILS: Suggest how to revise the details of the event.

## Attention

1. Ensure that all plot events and character developments align with the overall narrative structure.
2. All suggestions modifications should be based on the context provided in the plot lines and character profiles. DO NOT introduce new characters unless explicitly required.
3. PROHIBITE adding new plots. DO NOT add new events to any act. DO NOT introduce any new events in Plot Chains List.
4. Refer to the Issues History for past issues but avoid repeating them.
5. Some acts may have more than one issue. Some acts may have no issue. If there are no issue in all acts, simply output "No errors or inconsistencies found."

## Output Example

Your final output should ALWAYS strictly in the following format example:

{output_format}
"""

USER_REFINE = """Review and refine the Plot Lines across all acts, provide suggested modification based on the following materials:

## Plot Lines
{plot_lines}

## Issues History about Plot Lines
{history1}

## Character Profiles
{profiles}
"""

# 4. Sort the issues found by severity, putting issues with high severity at the top, issues with low severity at the bottom.

# 输入全幕情节链、角色传记、历史修改意见，对角色传记提出若干修改意见
SYSTEM_REFINE2 = """
You are a executive observer expert skilled in identifying inconsistencies and errors in narrative plots and character developments. Your goal is to review and refine the character profiles across all acts. You can refer to historical errors and suggestions in the Issues History, but try not to repeat them.

## Steps

You will check the character profiles by following these steps:
1. Understand, analyze, and break down the overall narrative structure and the roles of characters.
2. According to the narrative context and the provided plot lines and character profiles, think about the following five different types of issue:
   - RELATIONSHIP: Check whether the Character Relationships is reasonable and accurate.
   - EVENTS: Ensure that the events in Character Biographies align with the plot events in Plot Lines.
   - MONOLOGUE: Check whether the monologue in Character Biographies fits the character.
   - CHANGES: Check whether the psychology and desires changes in Character Biographies is reasonable and accurate.

3. Identify any errors or inconsistencies, and provide detailed suggested modification. 
   - RELATIONSHIP: Recommend rewriting or modifying the Character Relationships. e.g. Character A should be the father of Character B.
   - EVENTS: Specify which character's biographies should be revised. e.g. Character C should experience Act x-Event y.
   - MONOLOGUE: Specify which monologue should be revised. e.g. Character D's monologue for Act x-Event y doesn't fit him.
   - CHANGES: specify which changes should be revised. e.g. Character B's changes for Act x-Event y doesn't fit her.
   
## Attention

1. Focus on identifying errors and inconsistencies in the plot lines and character profiles.
2. Ensure that all plot events and character developments align with the overall narrative structure.
3. All suggestions modifications should be based on the context provided in the plot lines and character profiles. DO NOT introduce new characters or plot elements unless explicitly required.
4. Refer to the Issues History for past issues but avoid repeating them.
5. Some acts may have more than one issue. Some acts may have no issue. If there are no issue in all acts, simply output "No errors or inconsistencies found."

## Output Example

Your final output should ALWAYS strictly in the following format example:

{output_format}
"""

USER_REFINE2 = """Review and refine Character Profiles across all acts, provide suggested modification based on the following materials:

## Character Profiles
{profiles}

## Issues History about Character Profiles
{history2}

## Plot Lines
{plot_lines}
"""

# 输入单幕情节链、修改意见、小说原文片段，输出修改后的单幕情节链
SYSTEM_IMPROVE = """You are an expert in narrative structure and character development.

## Steps
1. Review the given Issue and Suggestion.
2. Read and understand the Reference Context and Character Profile thoroughly.
3. Revise the Original Plot Line, while ensuring consistency and alignment with the overall narrative structure.

## Output Format
Your Revised Plot Line should ALWAYS strictly be JSON format, same as the Original Plot Line.

## Attention
1. Ensure all changes align with the Suggestion and the Reference Context and Character Profile.
   1.1 If the Suggestion contradicts the Reference Context, do not change anything.
   1.2 If the Suggestion introduces new plots, events or characters that are not in the Reference Context and Character Profile, do not change anything.
2. PROHIBITE adding new plots. DO NOT add new events to any act. DO NOT introduce any new events in Plot Chains List.
3. ONLY revise elements related to the Suggestion. All the other elements should remain as is. Avoid introducing new elements.
4. Ensure all changes reflect the character’s development and the story’s logical progression.
"""
# 2. ONLY revise the {Act_ID} part. Avoid revising other Acts.

USER_IMPROVE = """
Revise the Original Plot Line based on the following materials:

## Issue and Suggestion
{suggestion}

## Reference Context
{context}

## Reference Character Profile
{profile}

## Original Plot Line
{plot_line}

## Output Format Example:
{output_format}
"""

# 输入单幕角色传记、修改意见、小说原文片段，输出修改后的单幕角色传记
SYSTEM_IMPROVE2 = """You are an expert in narrative structure and character development.

## Steps
1. Review the given Issue and Suggestion.
2. Read and understand the Reference Context and Reference Plot Line thoroughly.
3. Revise the Original Character Profile, while ensuring consistency and alignment with the overall narrative structure.

## Output Format
Your Revised Character Profile should ALWAYS strictly be JSON format, same as the Original Character Profile.

## Attention
1. Ensure all changes align with the Suggestion and the Reference Context and Reference Plot Line.
   1.1 If the Suggestion contradicts the Reference Context, do not change anything.
   1.2 If the Suggestion introduces new plots, events or characters that are not in the Reference Context and Reference Plot Line, do not change anything.
2. ONLY revise elements related to the Suggestion. All the other elements should remain as is. Avoid introducing new elements unless absolutely necessary.
3. Ensure all changes reflect the character’s development and the story’s logical progression.
"""

USER_IMPROVE2 = """
Revise the Original Character Profile based on the following materials:

## Issue and Suggestion
{suggestion}

## Reference Context
{context}

## Reference Plot Line
{plot_line}

## Original Character Profile
{profile}

## Output Format Example:
{output_format}
"""

# 输入全幕情节链，输出提取到的因果关系
SYSTEM_DAG = """You are a professional screenwriter. You need to extract the causal relationships from the given plot chain.

## Steps:

1. Read and Analyze:
   - You will reveive the Plot Lines, please read and understand them thoroughly.

2. Extract Causal Relationship:
   - Extract the causal relationships from the Plot Lines.
   - The causal relationships should be in the format of "Cause -> Effect".

## Attention:

- You should ensure that any two events can be connected by some relationship.
- Avoid duplication of the Existing Causal Relationships.

## Output Example:

Your final output should ALWAYS strictly in the following format example:

{output_format}
"""

USER_DAG = """Extract the causal relationships from the given Plot Lines.

## Plot Lines
{plot_lines}

## Existing Causal Relationship
{plots_edges}
"""

# -------------------------------------------------------#

SYSTEM_GENERATE_SCRIPT = """
Assume you are a professional screenwriter. You need to convert a given novel chapter content into a correct screenplay format. Ensure that all scenes, dialogues, actions, and character expressions in the novel are converted into the screenplay and that the screenplay has the correct format.

Here is the input format:

### Input format:
The Given Chapter Content:
[Chapter Content]
Previously on the Episode:
[Previously Summary]

Please follow the output format closely.

### Output format:
Screenplay Content:
[Screenplay Content]
"""
USER_GENERATE_SCRIPT = """
Based on the given chapter content and the previously summary, convert it into a correct screenplay format. Ensure that all scenes, dialogues, actions, and character expressions in the novel are converted into the screenplay and that the screenplay has the correct format.

The Given Chapter Content:
{chapter_content}
Previously on the Episode:
{previous_summary}
"""


def extract_raw_script(response: str) -> str:
    """
    从模型响应中提取剧本部分

    参数:
    response (str): 模型的完整响应

    返回:
    str: 剧本内容
    """
    # 定义剧本部分的开始标记
    screenplay_start_marker = "Screenplay Content:"
    
    # 查找开始标记的位置
    screenplay_start_pos = response.find(screenplay_start_marker)
    
    # 如果没有找到开始标记，返回空字符串
    if screenplay_start_pos == -1:
        return ""
    
    # 提取剧本内容
    screenplay_content = response[screenplay_start_pos + len(screenplay_start_marker):].strip()
    
    return screenplay_content


EXTRACT_SCRIPT_SYSTEM = """
Assume you are a professional screenwriter and information extractor. Your task is to extract detailed information from a given screenplay. In each scene, ensure to identify different scenes, the dialogues for each character, and describe the character psychology based on their dialogues, actions, expressions, and camera descriptions. The dialogues for each character should be a list. If the character are no dialogues, provide an empty list.

Here is the input format:

### Input format:
Screenplay Content:
[Screenplay Content]

Please follow the output format closely.

### Output Example:
Extracted Information:
```json
{
    "scenes_info": [
        {
            "scene_setting": "Setting description of scene 1",
            "characters_info": {
                "character_1": {
                    "dialogues": [The dialogues list of character 1.],
                    "psychology": "How the character 1 psychology changed",
                },
                "character_2": {
                    "dialogues": [The dialogues list of character 2.],
                    "psychology": "How the character 2 psychology changed",
                }
            }
        },
        {
            "scene_setting": "Setting description of scene 2",
            "characters_info": {
                "character_1": {
                    "dialogues": [The dialogues list of character 1.],
                    "psychology": "How the character 3 psychology changed",
                },
                "character_4": {
                    "dialogues": [The dialogues list of character 4.],
                    "psychology": "How the character 4 psychology changed",
                }
            }
        }
    ]
}
```
"""

EXTRACT_SCRIPT_USER = """
Based on the given screenplay content, extract detailed information. Ensure to identify different scenes, the dialogues for each character in each scene, and describe the character psychology based on their dialogues, actions, expressions, and camera descriptions.

Screenplay Content:
{screenplay_content}
"""
def _delete_char_label(text,char='#'): #删掉首尾的特定字符
    text=text.strip()
    while text and text.startswith(char):
        text = text[1:].strip()
    while text and text.endswith(char):
        text = text[:-1].strip()
    return text
def _delete_json_label(text): #删掉首尾的```json 和```
    text=text.strip()
    while text and text.startswith('```json'):
        text = text[7:].strip()
    while text and text.endswith('```'):
        text = text[:-3].strip()
    return text

def extract_dict_info(response: str) -> dict:
    """
    从模型响应中提取详细信息部分

    参数:
    response (str): 模型的完整响应

    返回:
    dict: 提取的详细信息
    """
    response = response.replace("(narration only)","").replace("(narration and actions only)","")

    def get_result(response,pattern):
        regex = re.compile(pattern, re.DOTALL)
        matches = regex.finditer(response)
        result = [match.group() for match in matches]
        return result
    response = response.replace('Extracted Information:\n\n```json','Extracted Information:\n```json')
    result = get_result(response,r'Extracted Information:\n```json.*\n```')
    if result:
        script_info_content = result[0].replace('Extracted Information:\n```json','').replace('\n```','').strip()
    else:
        # 提取详细信息部分
        script_info_start_marker = "Extracted Information:"
        # 查找开始标记的位置
        script_info_start_pos = response.find(script_info_start_marker)
        # 如果没有找到开始标记，返回空字典
        if script_info_start_pos == -1:
            return {}
        # 提取详细信息内容
        script_info_content = response[script_info_start_pos + len(script_info_start_marker):].strip()
    
        if not script_info_content:
            script_info_content = _delete_json_label(response)
        

    # 将提取的内容转换为字典
    try:
        script_info = json.loads(script_info_content)
    except json.JSONDecodeError:
        # print(f"    warning extract_dict_info: missing json!")
        script_info = {}
    
    return script_info


EXTRACT_CHAPTER_SYSTEM = """
Assume you are a professional screenwriter and information extractor. Your task is to extract detailed information from a given chapter's content and the previous summary. Ensure to identify the main conflict in the chapter plots, scene settings, character psychology changes, and character relation changes based on the chapter content.
Main Conflict: The main contradiction in the chapter plot, is the driving force behind the development of the plot.
Scene Settings: What scenes are included in the chapter, and the description of the scenes should be as accurate as possible.
Character Psychological Changes: What inner psychological changes have occurred in these characters during the development of the plot?
Character Relationship Changes: What relationship changes have occurred between different characters during the development of the plot?

Here is the input format:

### Input format:
The Given Chapter Content:
[Chapter Content]
The Previous Summary:
[Previous Summary]

Please follow the output format closely.

### Output format:
Extracted Information:
```json
{
    "main_conflict": "Main conflict description",
    "scene_settings": [
        {
            "scene": "EXT. OFFICE BUILDING - DAY",
            "description": "description of this scene"
        },
        {
            "scene": "INT. OFFICE HALLWAY - DAY",
            "description": "description of this scene"
        }
    ],
    "character_psychology": {
        "character_1": [
            "the first inner psychological changes of character_1",
            "the second inner psychological change of character_1"
        ],
        "character_2": [
            "the first inner psychological change of character_2",
            "the second inner psychological change of character_2"
        ]
    },
    "character_relations": {
        "character_1 and character_2": "the relationship change between character_1 and character_2",
        "character_2 and character_3": "the relationship change between character_2 and character_3",
    }
}
```
"""

EXTRACT_CHAPTER_USER = """
Based on the given chapter content and the previous summary, extract detailed information. Ensure to identify the main conflict in the chapter plots, scene settings, character psychology changes, and character relationship changes based on the chapter content.

The Given Chapter Content:
{chapter_content}
The Previous Summary:
{previous_summary}
"""


GEN_SCENE_SYSTEM = """
Assume you are a professional screenwriter and story rewriter. Your task is to rewrite the given script based on the main conflict and scene settings using a three-act structure: Setup, Conflict, and Resolution. Ensure that the rewritten episode is engaging and includes some twists while maintaining the overall storyline. This will help ensure your rewritten screenplay is engaging, and don't be afraid to throw in a few twists here and there. The rewritten screenplay just needs to follow the basic plot of the original script, allowing for adaptations.

Here is the input format:

### Input format:

- Original Script:
[Script Content]

- Main Conflict:
[Description of the main conflict in the plot]

- Scene List:
[Some Scenes]

Please follow the output format closely:

### Output format:

Three-Act Structure:
```json
{
    "Setup": "Description of the setup scenes",
    "Conflict": "Description of the conflict scenes",
    "Resolution": "Description of the resolution scenes"
}
```

Rewritten Episode:
[Here is the Rewritten Episode Content]
"""
GEN_SCENE_USER = """
Based on the given original script, main conflict, and scene list, rewrite the script using a three-act structure: Setup, Conflict, and Resolution. Ensure that the rewritten episode is engaging and includes some twists while maintaining the overall storyline. This will help ensure your rewritten screenplay is engaging, and don't be afraid to throw in a few twists here and there. The rewritten screenplay just needs to follow the basic plot of the original script, allowing for adaptations.

- Original Script:
{raw_script}

- Main Conflict:
{main_conflict}

- Scene List:
{scene_settings}
"""

def extract_three_act(response: str) -> dict:
    """
    从模型响应中提取字典部分

    参数:
    response (str): 模型的完整响应

    返回:
    dict: 提取的字典信息，包括三幕结构和改编的剧本
    """

    # 提取字典部分
    dict_start_marker = "Three-Act Structure:"
    script_start_marker = "Rewritten Episode:"
    
    # 查找开始标记的位置
    dict_start_pos = response.find(dict_start_marker)
    script_start_pos = response.find(script_start_marker)
    
    # 如果没有找到开始标记，返回空字典
    if dict_start_pos == -1 or script_start_pos == -1:
        return {}
    
    # 提取字典内容和改编的剧本内容
    dict_content = response[dict_start_pos + len(dict_start_marker):script_start_pos].strip()
    script_content = response[script_start_pos + len(script_start_marker):].strip()
    dict_content = _delete_char_label(dict_content,'-')
    # script_content = _delete_char_label(script_content,'-')
    dict_content = _delete_char_label(dict_content,'#')
    # script_content = _delete_char_label(script_content,'#')
    dict_content = _delete_json_label(dict_content)
    # script_content = _delete_json_label(script_content)

    # 另一方法获取dict
    # def get_result(response,pattern):
    #     regex = re.compile(pattern, re.DOTALL)
    #     matches = regex.finditer(response)
    #     result = [match.group() for match in matches]
    #     return result
    # # response = response.replace('Three-Act Structure:\n\n```json','Three-Act Structure:\n```json')
    # result = get_result(response,r'Three-Act Structure:\n```json.*\nRewritten Script:').strip()
    # if result:
    #     if result.endwith('```'):
    #         result = result[:-3].strip()
    #     dict_content = result[0].replace('Three-Act Structure:\n```json','').strip()

    # 将提取的内容转换为字典
    try:
        extracted_dict = json.loads(dict_content)
        extracted_dict["rewritten_script"] = script_content
    except json.JSONDecodeError:
        # print(f"\n[Failed!] [dict_content] Start\n\n{dict_content}\n\n[Failed!] [dict_content] End\n")
        extracted_dict = {}
    
    return extracted_dict


GEN_DIAG_SYSTEM = """
Assume you are a professional screenwriter and dialogue expert. Your task is to rewrite the given episode's dialogues based on character psychology and relationship changes. You need to either merge or expand the dialogues to ensure that the dialogue between characters is consistent with the psychological changes and relationship changes of the characters and that the rewritten dialogue is appropriate and fluent. Please adapt and polish the character dialogue according to the requirements and give the Dialogue Adaptations Reason.
If the Dialogues Limit is not None, ensure the total number of dialogues falls within the given limit (Dialogues Limit). If the Dialogues Limit is None, polish the dialogues according to the provided character psychology and relationship changes by yourself.

Here is the input format:

### Input format:

Original Episode:
[Episode Content]

Character Psychology Changes:
[Description of character psychology changes]

Character Relationship Changes:
[Description of character relationship changes]

Dialogues Limit:
[Dialogues Limit]

Please follow the output format closely.

### Output format:

Dialogue Adaptations Reason:
[Explanation for how and why the dialogues were adapted]

Rewritten Episode:
[Here is the Rewritten Episode Content]
"""

GEN_DIAG_USER = """
Based on the given original episode, character psychology changes, and character relationship changes, rewrite the episode's dialogues. Merge or expand the dialogues to ensure that the dialogue between characters is consistent with the psychological changes and relationship changes of the characters and that the rewritten dialogue is appropriate and fluent. Please adapt and polish the character dialogue according to the requirements and give the Dialogue Adaptations Reason.
If the Dialogues Limit is not None, ensure the total number of dialogues falls within the given limit (Dialogues Limit). If the Dialogues Limit is None, polish the dialogues according to the provided character psychology and relationship changes by yourself.

Original Episode:
{raw_script}

Character Psychology Changes:
{character_psychology}

Character Relationship Changes:
{character_relations}

Dialogues Limit:
{dialogues_limit}
"""

def extract_dialogue_changes(response: str) -> dict:
    """
    从模型响应中提取对话修改依据和修改后的剧本部分

    参数:
    response (str): 模型的完整响应

    返回:
    dict: 提取的对话修改依据和修改后的剧本
    """
    reasoning_start_marker = "Dialogue Adaptations Reason:"
    script_start_marker = "Rewritten Episode:"
    
    # 查找开始标记的位置
    reasoning_start_pos = response.find(reasoning_start_marker)
    script_start_pos = response.find(script_start_marker)
    
    # 如果没有找到开始标记，返回空字典
    if reasoning_start_pos == -1 or script_start_pos == -1:
        return {}
    
    # 提取对话修改依据和修改后的剧本内容
    reasoning_content = response[reasoning_start_pos + len(reasoning_start_marker):script_start_pos].strip()
    script_content = response[script_start_pos + len(script_start_marker):].strip()
    
    # 将提取的内容转换为字典
    extracted_info = {
        "dialogue_adaptation_reason": reasoning_content,
        "rewritten_script": script_content
    }
    
    return extracted_info


GEN_ACT_SYSTEM = """
Assume you are a professional screenwriter and action scene expert. Your task is to rewrite the given episode's actions and camera shot descriptions based on character psychology and relationship changes. You need to polish and adjust the actions and camera shot descriptions to ensure they align with the psychological changes and relationship changes of the characters. the descriptive language you use should be beautiful and easy to understand. 

If the Descriptions Limit is not None, ensure that the length of the descriptions approaches the given Descriptions Limit while remaining consistent with the character's psychology and relationship changes. The Descriptions Limit can be described as follows: very few, few, moderate, many, or many more. 

Here is the input format:

### Input format:

Original Episode:
[Episode Content]

Character Psychology Changes:
[Description of character psychology changes]

Character Relationship Changes:
[Description of character relationship changes]

Descriptions Limit:
[Episode Descriptions Limit]

Please follow the output format closely.

### Output format:

Description Adaptations Reason:
[how and why adapt the actions and camera shots descriptions]

Rewritten Episode:
[Here is the Rewritten Episode Content]
"""

GEN_ACT_USER = """
Based on the given original episode, character psychology changes, and character relationship changes, rewrite the episode's actions and camera shot descriptions. Ensure they align with the psychological changes and relationship changes of the characters. The descriptive language you use should be beautiful and easy to understand.

If the Descriptions Limit is not None, ensure that the length of the descriptions approaches the given Descriptions Limit while remaining consistent with the character's psychology and relationship changes. The Descriptions Limit can be described as follows: very few, few, moderate, many, or many more. 


Original Episode:
{raw_script}

Character Psychology Changes:
{character_psychology}

Character Relationship Changes:
{character_relations}

Descriptions Limit:
{action_limit}
"""

def extract_action_changes(response: str) -> dict:
    """
    从模型响应中提取动作和镜头修改依据和修改后的剧本部分

    参数:
    response (str): 模型的完整响应

    返回:
    dict: 提取的动作和镜头修改依据和修改后的剧本
    """
    reasoning_start_marker = "Description Adaptations Reason:"
    script_start_marker = "Rewritten Episode:"
    
    # 查找开始标记的位置
    reasoning_start_pos = response.find(reasoning_start_marker)
    script_start_pos = response.find(script_start_marker)
    
    # 如果没有找到开始标记，返回空字典
    if reasoning_start_pos == -1 or script_start_pos == -1:
        return {}
    
    # 提取动作和镜头修改依据和修改后的剧本内容
    reasoning_content = response[reasoning_start_pos + len(reasoning_start_marker):script_start_pos].strip()
    script_content = response[script_start_pos + len(script_start_marker):].strip()
    
    # 将提取的内容转换为字典
    extracted_info = {
        "description_adaptation_reason": reasoning_content,
        "rewritten_script": script_content
    }
    
    return extracted_info


SUMMARIZE_SYSTEM = """
Assume you are a professional screenwriter. Your task is to summarize the given rewritten episode into a coherent and concise plot summary. This summary should encapsulate the key events, character developments, and main plot points of the episode. Then, you need to generate an overall plot summary based on all the plot summaries so far, including the plot summary of the current episode you have generated, to be used as a previously summary for the subsequent episode generation process.

Here is the input format:

### Input format:

Rewritten Episode:
[Rewritten Episode Content]

Previous Plot Summaries:
[Previous Plot Summaries]

Please follow the output format closely.

### Output format:

Current Plot Summary:
[Summary of the plot and key events of the episode]

Overall Plot Summary:
[Overall summary combining all previous summaries with the current plot summary]
"""
SUMMARIZE_USER = """
Based on the given rewritten episode and previous plot summaries, summarize the episode into a coherent and concise plot summary. This summary should encapsulate the key events, character developments, and main plot points of the episode. Combine this summary with the previous plot summaries to create an overall plot summary to be used as a previously summary for the subsequent episode generation process.

Rewritten Episode:
{rewritten_script}

Previous Plot Summaries:
{episode_summaries}
"""

def extract_episode_summary(response: str) -> tuple:
    """
    从模型响应中提取情节总结部分

    参数:
    response (str): 模型的完整响应

    返回:
    tuple: 当前情节总结和整体情节总结
    """
    summary_start_marker = "Current Plot Summary:"
    overall_summary_marker = "Overall Plot Summary:"
    
    # 查找开始标记的位置
    summary_start_pos = response.find(summary_start_marker)
    overall_summary_pos = response.find(overall_summary_marker)
    
    # 如果没有找到开始标记，返回空字符串
    if summary_start_pos == -1 or overall_summary_pos == -1:
        return "", ""
    
    # 提取当前情节总结和整体情节总结
    current_summary_content = response[summary_start_pos + len(summary_start_marker):overall_summary_pos].strip()
    overall_summary_content = response[overall_summary_pos + len(overall_summary_marker):].strip()
    
    return current_summary_content, overall_summary_content

SYSTEM_FORMAT_PROMPT = """Assume you are a professional screenwriter. You need to revise a given script episode into a correct screenplay format. Follow the detailed instructions below to ensure the script is accurate and in the required format. 

### Task Overview: 

1. Understanding the Content: 
    - You will receive the following materials: 
        - The content of given episode from script. 
        - The short play script example. 

2. Script Format and Style:
    - Closely follow the format and style of The Short Play Script Example. 
    - Delete the narration.
    - Keep the dialogue and descriptions succinct. Focus on action and drama.
    - Emphasizing dialogue and character actions. Please only use double quotes to indicate the characters' speech. 
    - Avoid too long extensive psychological descriptions and general plot summaries, delete or rewrite them into dialogue, action or scene descriptions  
    - Each of your scene titles should follow the following format: For locations, INT. Means interior, EXT. Means exterior; For time, DAY means day and NIGHT means night; Locations and time are separated by "-", all letters are capitalized, do not output other unnecessary formats. 
    - Only output the revised short play script, do not output explanations or other information. Follow the output format of The Short Play Script Example strictly.

Here is the input format:

### Input format:

The Content of Given Episode:
[The Content of Given Episode]

The Short Play Script Example:
[The Short Play Script Example]
"""

USER_FORMAT_PROMPT = """
### The Content of Given Episode:

{current_episode}

### The Short Play Script Example:

EPISODE TITLE: TERRIEBLE MISUNDERSTANDING
INT. LUXURY HOTEL ROOM - NIGHT 
On the screen, ANNA SMITH (a beautiful 23-year-old woman) 
passionately kissing RICHARD ANDERSON (a 29-year-old man) in a dimly lit hotel room. They're on the bed. Richard responds eagerly to Anna's kiss, he undresses her, and soon both of their clothes are scattered on the floor. They engage in intimacy.
CUT TO: 
INT. LUXURY HOTEL ROOM - DAY 
The next day, Richard and Anna wrapped in a blanket. Richard hugs Anna from behind. Anna slowly opens her eyes, looking like she just woke up. She smiles happily. 
ANNA 
I'm glad I could give my first night to you, Ryan. 
Richard, behind her, kisses Anna's ear. 
RICHARD 
I'm glad if you're happy, Tiffany. 
Hearing the man behind her mention another woman's name, Anna quickly opens her eyes. She immediately gets out of bed and opens the hotel room curtains. The room brightens. 
ANNA 
(surprised) 
You're not Ryan! 
Richard is only wearing shorts, his body exposed. He rubs his eyes, the room brightened, he can see the woman in front of him is not TIFFANY (a 25-year-old woman, his girlfriend). 
RICHARD 
(still half asleep) 
Who are you! You're not Tiffany! 
ANNA 
This is room number 316. I'm not mistaken. This is my fiancé Ryan's room. 
Richard laughs. He quickly stands up and walks to grab a 
cigarette. 
RICHARD 
Just tell me how much money you want, then you have to leave immediately. 
SOUND EFFECT: Ding dong... Ding dong... 
The sound of the hotel room doorbell is heard. 
Anna quickly searches for her clothes and puts them on 
hurriedly.
ANNA 
That must be Ryan! He's looking for me. 
Anna puts on her clothes in a hurry. 
After putting on her clothes, Anna quickly grabs her bag and puts on her shoes, then rushes to open the door. 
ANNA 
Ryan! 
The door opens, revealing a laundry attendant. 
LAUNDRY ATTENDANT 
(smiling) 
Good morning, I have brought the clothes for Mr. Anderson. 
Anna looks at the man with disappointment. 
Richard stands beside Anna and takes the clothes from the 
server. 
RICHARD 
Thank you. 
LAUNDRY ATTENDANT 
You're welcome, Mr. Anderson. 
The laundry attendant leaves the room. Anna is still standing in place. Richard leaves her alone. He enters the room and writes a check. 
After writing the check, he returns to Anna and hands her the check. 
RICHARD 
Take this and go.
"""